package gov.va.med.mhv.journal.data.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name = "ACTIVITY_JOURNAL")
public class ActivityJournal implements Serializable {

	private static final long serialVersionUID = -5620838315239618652L;

	@Id
	@Column(name = "ACTIVITY_ID_SEQ")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long activityJournalId;

	@Column(name = "OPLOCK")
	private Integer oplock = 1;

	@Column(name = "COMMENTS")
	private String comments;

	@Column(name = "ACTIVITY_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date journalDate;

	@OneToMany(mappedBy = "activityJournal", fetch = FetchType.EAGER, cascade = CascadeType.ALL, orphanRemoval=true)
	@Fetch(FetchMode.SELECT)
	private Set<ActivityDetail> activityDetails;

	@Column(name = "USER_PROFILE_USER_PROFILE_ID")
	private Long userId;

	
/*	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "USER_PROFILE_USER_PROFILE_ID")
	private UserProfile userProfile;*/

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public Date getJournalDate() {
		return journalDate;
	}
	

	public Long getActivityJournalId() {
		return activityJournalId;
	}

	public void setActivityJournalId(Long activityJournalId) {
		this.activityJournalId = activityJournalId;
	}

	public void setJournalDate(Date journalDate) {
		this.journalDate = journalDate;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}


	public Set<ActivityDetail> getActivityDetails() {
		return activityDetails;
	}

	public void setActivityDetails(Set<ActivityDetail> activityDetails) {
		this.activityDetails = activityDetails;
	}
	

}
